
--[[  ______________________________________________
     |!!!!!     Black Hole Gun    !!!!!!|
     |!!!!!        v. 1.8         !!!!!|
     |!!!!!!!      By     !!!!!!!!!|
     |!!!!!  TrinitronX (enTity)  !!!!!!|
     |!!!!!      ROBO DONUT       !!!!!!|
     |!!!!         and           !!!!!|
     |!!!!!       dssalmon        !!!!!!|
     |!! vector/angle functions by  !!|
     |!!!!         GeoGriff           !!!!|
     |!!  gun inspired by NeoSeeker !!|
      
Feel free to use this, or modify it.. as long as you give the authors credit.  Thanks!
]]

-- global variables that can tweak the effects of the black hole (feel free to change them if wanted)

affectplayers = true; -- whether or not the black hole will suck players in (default true). Set to false to not pull in players.
affectnpcs = true; -- whether or not the black hole will suck in npcs (default true)

-- Shot related settings
local fieldtime = 10; --default is 7 (the amount of time the black hole is in effect for.. note that changing this may offset the black hole's sound effects)
local shotmovetime = 3; --default is 3 (the amount of time the black hole ball can move around)

-- Black hole related settings
blackholeforce = 90000000; --90000000 is default for the black hole's force.  Use less to give it less pull
blackholeouterradius = 300000; --default is 300000 (effects the outer/pulling radius of the black hole)
blackholeinnerradius = 70; --default is 70 (effects the inner deletion/kill radius of the black hole)

-- Field Of View related settings (only take effect if affectplayers is true)
affectplayerfov = true; -- whether or not to change player's fov (default true)
affectownerfov = false; -- whether or not to change owner's fov (default true)
minfov = 50; -- default is 50.  The minimum fov to set the player's view to (when they're maxleveldist units away)
maxfov = 200;  -- default is 200.  Very crazy upside down effect :P. Same as above, only max at 0 units away
maxleveldist = 3000; -- Try to set it to something less than or near the max distance of the level (for gm_construct.. this value is somewhere around 5500 game units)
-- maxleveldist effects the slope of the fov changes.  A larger distance makes the FOV change more quickly.



--Initialize Variables
local oldtime = 999999; -- because of the logic we're using to check if it's ok to turn on the black hole.. we want this value to be very high
blackhole = 0;
fieldtime = fieldtime + shotmovetime; -- fieldtime is going to be some time after shotmovetime is up

--============================Begin Function definitions============================
-- What's beyond this line is not for the weak of heart.  Only mess with this if you
--    know what you're doing.
-- Point-based gravity (By ROBO_DONUT)
-- Note: Do not set zerooffset to 0, this will cause infinite gravity at the center.

function bh_pointgrav(centervec,zerooffset,radius,force)
	for key,value in _EntitiesFindInSphere(centervec,radius) do -- Get the enities in the radius
		if (_phys.HasPhysics(value) and (value > _MaxPlayers())) then -- Make sure that the entity is a physics object
			local entpos = _EntGetPos(value)
			if ( centervec.x == entpos.x and centervec.y == entpos.y and centervec.z == entpos.z and _EntGetName(value) ~= "holebase" ) then return end
			--_PrintMessageAll(HUD_PRINTCENTER, "entpos is: "..vecString(entpos).."\ncentervec is: "..vecString(centervec))
			local gravforce = force * _phys.GetMass(value) / (vecLength(vecSub(centervec,entpos)) + (zerooffset)) ^ 2
			local entvec = vecNormalize(vecSub(centervec,entpos))
			local gravforcevec = vecMul(entvec,vector3(gravforce,gravforce,gravforce))
			_phys.ApplyForceCenter(value,gravforcevec)
		elseif ( (affectplayers == true) and (value <= _MaxPlayers()) and (value ~= 0) ) then -- Make sure the entity is a player
			local entpos = _EntGetPos(value)
			--if ( centervec.x == entpos.x and centervec.y == entpos.y and centervec.z == entpos.z ) then return end
			--_PrintMessageAll(HUD_PRINTCENTER, "entpos is: "..vecString(entpos).."\ncentervec is: "..vecString(centervec))
			local gravforce = force * _phys.GetMass(value) / (vecLength(vecSub(centervec,entpos)) + (zerooffset)) ^ 2
			local entvec = vecNormalize(vecSub(centervec,entpos))
			local gravforcevec = vecMul(entvec,vector3(gravforce,gravforce,gravforce))
			if (((affectplayerfov == true) and (value ~= Owner)) or ((affectownerfov == true) and (value == Owner))) then
				local dist = vecLength(vecSub(centervec, entpos));
				local fov = -((maxfov - minfov) / (maxleveldist)) * dist + maxfov ; --linearly change the player's FOV with respect to their distance from the black hole
				_PlayerSetFOV(value, fov, 0.1);
			end			
			
			-- Sucking up the owner would be bad... the holebase entity would not be removed
			if (value ~= Owner) then
				_EntSetVelocity(value, vecAdd(_EntGetVelocity(value), gravforcevec) ) 
			end
		end
		if ((string.find( _EntGetType( value ), 'npc_' ) ~= nil) and affectnpcs ) then -- Must be an NPC
			local entpos = _EntGetPos(value)
			local gravforce = force * 0.75 / (vecLength(vecSub(centervec,entpos)) + (zerooffset)) ^ 2
			local entvec = vecNormalize(vecSub(centervec,entpos));
			local gravforcevec = vecMul(entvec,vector3(gravforce,gravforce,gravforce));
			_EntSetVelocity(value, vecAdd(_EntGetVelocity(value), gravforcevec));
		end
	end
	for key2,value2 in _EntitiesFindInSphere(centervec, blackholeinnerradius) do
		if ( ((affectplayers == true) and (value2 <= _MaxPlayers()) and (value2 ~= Owner)) or ((string.find(_EntGetType(value2), 'npc_') ~= nil) and affectnpcs and not(string.find(_EntGetType(value2), 'roller') or string.find(_EntGetType(value2), 'turret'))) ) then
			_TraceAttack(value2, Owner, Owner, 99999); -- Kill the player or npc using TraceAttack instead of PlayerKill so that our sexy deathicon will display ;)
		elseif ( _phys.HasPhysics( value2 ) and (value2 ~= holebase or value2 ~= holeeffect) and (value2 > _MaxPlayers())) then
			_EntRemove( value2 );
		end
	end
	
end

-- Vector to angle function (By GeoGriff)
function vecToAngle(unitVec)
    local elevAngle = math.asin(unitVec.z);
    local dirAngle = math.acos(unitVec.x / math.cos(elevAngle));
    if (unitVec.y < 0) then
        dirAngle = -(dirAngle);
    end
    return vector3(math.deg(dirAngle), math.deg(elevAngle), 0);
end
-- Angle to Vector function (By GeoGriff)
function angleToVec(angleVec)
    return vector3(math.cos(math.rad(angleVec.x)) * math.cos(math.rad(angleVec.y)), math.sin(math.rad(angleVec.x)) * math.cos(math.rad(angleVec.y)), math.sin(math.rad(angleVec.y)));
end 

--============================Begin Gun Functions============================
-- Effect creation function. Creates the black hole effect at some point, with some angle.  Also Spawns two planar distortion effects, perpendicular to the player's shoot angle (and black hole portal)

function bh_createEffect(point, angle)
	-- A lazy way to spawn 2 effects with opposite orientations
	for i = 1, -1, -2 do
		local effect1 = _EntCreate( "prop_dynamic" );
		_EntSetName( effect1, "holebase"..Owner );
		_EntPrecacheModel( "models/props_combine/portalball.mdl" );
		_EntSetModel( effect1, "models/props_combine/portalball.mdl");
		
		_EntSetAng( effect1, vecMul(vector3(i,i,i),angle));
		_EntSetPos( effect1, point);
		_EntSpawn( effect1 );
		_EntFire( effect1, "disableshadow", "", "0");
	end


	_PlaySound("npc/strider/charging.wav");
	--_EntEmitSoundEx(holeeffect, "npc/vort/health_charge.wav", 1, 1);
	_PlaySound("npc/vort/health_charge.wav");
	-- Create distortion effect on a portalrift
	
	-- Another amazingly lazy way I figured out to spawn 2 planes, with opposite orientations
	for i = 1, -1, -2 do
		orthogonalVector = vecToAngle(angle);
		orthogonalVector.y = i*(plyang.y + 90);
		orthogonalVector = angleToVec(orthogonalVector); 
		
		local effect2 = _EntCreate('prop_dynamic');
		_EntPrecacheModel("models/Effects/portalrift.mdl");
		_EntSetModel(effect2, "models/Effects/portalrift.mdl");
		_EntSetMaterial(effect2, "effects/strider_bulge_dudv");
		_EntSetPos(effect2, point);
		_EntSetAng(effect2, orthogonalVector);
		_EntSetName(effect2, "holebase"..Owner);
		_EntSpawn(effect2);
		_EntFire( effect2, "disableshadow", "", "0");
	end
end

-- Creates a smoketrail ent on some entity given an entid
-- Used to create the burning smoke effect on the gun's shells
function bh_smoketrail(entid)
	-- The iSmoke is the smoke that comes from the holeshell
	iSmoke = _EntCreate( "env_smoketrail" );
	_EntSetPos( iSmoke, _EntGetPos(entid) );
	_EntSetKeyValue( iSmoke,"smokesprite","sprites/whitepuff.spr" )
	_EntSetKeyValue( iSmoke,"firesprite","sprites/firetrail.spr" )
	-- Change these if you want to change the size of the smoke.
	-- Spawnradius is the distance of the smoke from it's entity.
	-- Endsize is the size that the smoke ends at.
	_EntSetKeyValue( iSmoke,"spawnradius", "0" )
	_EntSetKeyValue( iSmoke, "startsize", "15")
	_EntSetKeyValue( iSmoke,"endsize", "30" )
	-- Change this value to change the color of the smoke. Pretty self-explanatory.
	-- Just imagine- red smoke changing to blue!
	_EntSetKeyValue( iSmoke,"startcolor","0 0 0" )
	_EntSetKeyValue( iSmoke,"endcolor","160 160 160" )
	-- This is how long the smoke lasts
	_EntSetKeyValue( iSmoke,"lifetime","3" )
	_EntSetKeyValue( iSmoke, "emittime", "5" )
	_EntSetKeyValue( iSmoke, "minspeed", "10")
	_EntSetKeyValue( iSmoke, "maxspeed", "20")
	-- This is how much smoke is made
	_EntSetKeyValue( iSmoke,"spawnrate","50" )
	-- This is the opacity, or transparency of the smoke. Higher is denser.
	_EntSetKeyValue( iSmoke,"opacity","0.25" )
	_EntEmitSoundEx( iSmoke, "ambient/fire/ignite.wav",1.0,1.0)
	_EntFire(entid, "ignite", "", "1.5");
	_EntSetParent( iSmoke, entid )
	_EntSpawn( iSmoke);
end

-- Creates an explosion effect at some point, with some angle
-- Used when a player shoots the dark matter energy containment field ( nice random name eh? )
function bh_shotexplosion(point, angle)
	_EffectInit();
	_EffectSetStart(point);
	_EffectSetOrigin(point);
	_EffectSetAngles(angle);
	_EffectSetScale(5);
	_EffectSetMagnitude(5);
	_EffectSetRadius(60);
	_EffectDispatch("HelicopterMegaBomb");	
end

-- Creates a rollerball (dark matter energy containment field) at some point and angle
-- Also spawns an expended dark matter shell casing (which, being white hot, promptly bursts into flames)
-- Used whenever the gun fires
function bh_createBall(point, angle)
	local holebase = _EntCreate( "prop_physics" ); -- Make the ball
	local holeshell = _EntCreate( "prop_physics_multiplayer" ); -- Make the core
	_EntSetKeyValue( holebase, "targetname", "holeball"..Owner);
	_EntSetName( holebase, "holeball"..Owner);
	
	-- Set name of the shell
	_EntSetName( holeshell, "holeshell"..Owner);

	--[[ USEFUL MODELS:
     		models/props_junk/sawblade001a.mdl
     		models/effects/combineball.mdl
     		models/props_combine/portalball.mdl
	    	models/roller.mdl
	]]

	-- Precache the model for the rollerball
	_EntPrecacheModel( "models/roller.mdl" );
	_EntSetModel( holebase,"models/roller.mdl" );
	--_EntSetMaterial( holebase, "Models/effects/comball_sphere");
	_EntSetMaterial( holebase, "models/props_combine/tprings_globe");

	-- Precache the model for the core
	_EntPrecacheModel("models/items/combine_rifle_ammo01.mdl");
	_EntSetModel( holeshell, "models/items/combine_rifle_ammo01.mdl");
	--[[ USEFUL MATERIALS
		Tank Glass: models/props_lab/Tank_Glass001
		Combine Sphere: Models/effects/comball_sphere
		Portalball: models/props_combine/portalball001_sheet
		tpringsglobe?: models/props_combine/tprings_globe

	  ]]
	-- I decided upon the portalball material for the white-hot spent shell casings
	_EntSetMaterial( holeshell, "models/props_combine/portalball001_sheet");

	-- Set the angle and position for the ball and core
	_EntSetAng( holebase, angle );
	--_EntSetPos( holebase, vecAdd( point, vector3(0,0,-15)));
	_EntSetPos(holebase,vecAdd(point,vecMul(angle,vector3(26,26,0))));	
	
	_EntSetAng( holeshell, angle );
	--_EntSetPos( holeshell, vecAdd( point, vector3(-20, -20,-20)));
	_EntSetPos(holeshell,vecAdd(point,vecMul(angle,vector3(25,25,0))))
	_EntSpawn( holeshell );
	bh_smoketrail(holeshell);
	bh_shotexplosion(vecAdd(point, vecMul(angle, vector3(30,30,0))), angle);
	_phys.ApplyForceCenter( holeshell, vecMul(angle, vector3(1,1,1)));
	_EntFire( holeshell, "kill", "", 5 );

	_phys.EnableGravity(holeshell, true);
	_phys.EnableDrag(holeshell, true);
	_phys.EnableDrag(holebase,false);
	--_EntEmitSoundEx( holebase, "npc/combine_gunship/gunship_engine_loop3.wav", 3, 1);
	_EntEmitSoundEx( holebase, "npc/scanner/cbot_discharge1.wav", 1, 1);
	local power = 1000000;
	local fireforce = vecMul(angle, vector3(power, power, power));
	-- Spawn the ball
	_EntSpawn( holebase );
	
	-- Get rid of the ball once we're done with it
	_EntFire( holebase,"kill","", fieldtime );
	
	-- Disable gravity for the ball, and apply a force to it
	_phys.EnableGravity( holebase, false );
	_phys.ApplyForceCenter(holebase, fireforce);
	
end

-- Kills the black hole, and plays sounds.  Also sets all player's FOV back to normal
function bh_stopHole()
	-- kill the black hole effects
	local holebase = _EntGetByName("holebase"..Owner);
	for key,value in _EntitiesFindByName("holebase"..Owner) do
		_EntFire( value, "kill","", "0" );
	end
	oldtime = 9999999; -- we don't want to be executing this case a lot
	blackhole = 0;
	sound2 = 0;
	if (holebase ~= 0) then
		_PlaySound("npc/vort/attack_shoot.wav");
	else
		_PlaySoundPlayer(Owner, "buttons/combine_button_locked.wav");
	end
	-- Reset all player's FOV to default
	for i=1, _MaxPlayers(), 1 do
		_PlayerSetFOV(i, 90, 0);
	end
end

-- Creates a tesla effect on the dark matter energy containment field
function bh_tesla(entid)
	-- initialize random number generator
	math.randomseed( _CurTime() );
	math.random(); math.random(); math.random();
	-- Get random number for sound
	local randzapnum = math.random(4);
	_EffectInit();
	_EffectSetEnt(entid);
	_EffectSetStart(_EntGetPos(entid));
	_EffectSetScale(5);
	_EffectSetMagnitude(5);
	_EffectSetRadius(60);
	_EffectDispatch("TeslaHitBoxes");
	_EntEmitSoundEx(entid, "weapons/physcannon/superphys_small_zap"..randzapnum..".wav",5.0,1.0);
end

-- Creates effects for when the rollerball explodes, and the black hole opens up
function bh_ballexplode(entid, angle)
	-- initialize random number generator
	math.randomseed( _CurTime() );
	math.random(); math.random(); math.random();
	-- Get random number for sound
	local randsndnum = math.random(4, 5);
	_EffectInit();
	_EffectSetEnt(entid);
	_EffectSetStart(_EntGetPos(entid));
	_EffectSetOrigin(_EntGetPos(entid));
	--_EffectSetAngles(angle);
	_EffectSetScale(1.0);
	_EffectSetMagnitude(1.0);
	_EffectSetRadius(100.0);
	_EffectDispatch("cball_bounce");
	_PlaySound("weapons/physcannon/energy_disintegrate"..randsndnum..".wav");
end

-- Creates effects for when the black hole destabilizes and implodes
function bh_holeexplode(entid)
	-- initialize random number generator
	math.randomseed( _CurTime() );
	math.random(); math.random(); math.random();
	-- Get random number for sound
	local randsndnum = math.random(8, 9);
	_EffectInit();
	_EffectSetEnt(entid);
	_EffectSetStart(_EntGetPos(entid));
	_EffectSetOrigin(_EntGetPos(entid));
	_EffectSetScale(1.0);
	_EffectSetMagnitude(1.0);
	_EffectSetRadius(100.0);
	_EffectDispatch("cball_explode");
	_EffectDispatch("HelicopterMegaBomb");
	--_EntEmitSoundEx(entid, "ambient/explosions/explode_"..randsndnum..".wav", 1.0 , 1.0);
	_PlaySound("ambient/explosions/explode_"..randsndnum..".wav");
	randsndnum = math.random(3, 5);
	_PlaySound("weapons/explode"..randsndnum..".wav");
end
--============================End Function Definitions============================
--============================Begin Weapon Script Functions============================

function onInit( )
	--_SWEPSetSound( MyIndex, "single_shot", "weapons/mortar/mortar_fire1.wav" );
	_SWEPSetSound( MyIndex, "single_shot", "weapons/mortar/mortar_fire1.wav"); -- Set this to nothing.. since only the owner of the gun can hear it
	
	
end

function onThink( )
	-- We need to make sure holebase is the entity's id number still (removing entities screws with the entity id's)
	local holeball = _EntGetByName("holeball"..Owner);
	local holebase = _EntGetByName("holebase"..Owner);
	if (holeball ~= 0) then bh_tesla(holeball); end
	--if ((holebase == 0) and (holeball == 0)) then return; end
	bholeloc = _EntGetPos( holebase );
	if (blackhole == 1) then
		bh_pointgrav( bholeloc, 1, blackholeouterradius, blackholeforce);
	end
	
	-- If the ball shot's movetime is up, freeze it, kill it, and enable the hole
	if ((oldtime + shotmovetime <= _CurTime()) and (holeball ~= 0)) then
		_EntSetPos( holebase, _EntGetPos( holebase ));
		_phys.EnableMotion( holebase, false);
		
		bh_ballexplode( holeball, plyang );
		bh_createEffect(_EntGetPos(holeball), plyang);
		_EntFire( holeball, "kill", "", 0);
		
	end
	
	if((oldtime + shotmovetime + 3 <= _CurTime() and sound2 ~= 1)) then
		_PlaySound("npc/vort/health_charge.wav");
		bh_holeexplode(holebase);
		--_PlaySound("ambient/energy/force_field_loop1.wav");
		sound2 = 1;
		blackhole = 1;
	end
	
	if ((oldtime + fieldtime <= _CurTime()) and (blackhole ~= 0)) then
		bh_holeexplode(holebase);
		bh_stopHole();
	end
	
	
	return;
end

function onPrimaryAttack( )
	if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
	-- Play the weapon sound
	_EntEmitSoundEx(Owner, "weapons/mortar/mortar_fire1.wav", 1.0, 1.0);
	
	blackhole = 0;
	sound2 = 0;
	
	plyang = _PlayerGetShootAng(Owner);
	plypos = _PlayerGetShootPos(Owner);
	
	-- Shoot the ball
	bh_createBall(plypos, plyang);
	
	-- Use the gun's ammo
	_SWEPUseAmmo(MyIndex, 0 , 1);
	
	-- Set our current time
	oldtime = _CurTime();
end

function onSecondaryAttack( )
	local holeball = _EntGetByName("holeball"..Owner);
	local holebase = _EntGetByName("holebase"..Owner);
	if (holebase ~= 0) then
		bh_stopHole();
	elseif (holeball ~= 0) then
		oldtime = oldtime - shotmovetime;
	else
		bh_stopHole();
	end

end

function onDrop( Owner )
	local holebase = _EntGetByName("holebase"..Owner);
	local holeball = _EntGetByName("holeball"..Owner);
	if ((holebase ~= 0) or (holeball ~= 0)) then
		bh_holeexplode(holebase);
		bh_stopHole();
	end
end

function onRemove()
	local holebase = _EntGetByName("holebase"..Owner);
	local holeball = _EntGetByName("holeball"..Owner);
	if ((holebase ~= 0) or (holeball ~= 0)) then
		bh_holeexplode(holebase);
		bh_stopHole();
	end
end

function onReload( )
	return true;
end

function getWeaponSwapHands()
	return false; 
end

function getWeaponFOV()
	return 70; 
end

function getWeaponSlot()
	return 3; 
end

function getWeaponSlotPos()
	return 4; 
end

function getFiresUnderwater()
	return false;
end

function getReloadsSingly()
	return true;
end

function getDamage()
	return 75;
end

function getPrimaryShotDelay()
	return fieldtime;
end

function getSecondaryShotDelay()
	return 0.0;
end

function getPrimaryIsAutomatic()
	return false;
end

function getSecondaryIsAutomatic()
	return false;
end

function getPrimaryAmmoType()
	return "buckshot";
end

function getSecondaryAmmoType()
	return "none";
end

function getMaxClipPrimary()
	return 6;
end

function getMaxClipSecondary()
	return -1;
end

function getDefClipPrimary()
	return 6;
end

function getDefClipSecondary()
	return -1;
end
-- 0 = Don't override, shoot bullets, make sound and flash
-- 1 = Don't shoot bullets but do make flash/sounds
-- 2 = Only play animations
-- 3 = Don't do anything
function getPrimaryScriptOverride()
	return 1;
end

function getSecondaryScriptOverride()
	return 3;
end

function getBulletSpread()
	return vector3( 0.05, 0.05, 0.05 );
end

function getViewKick()
	return vector3( 2, 0.0, 0.0);
end

function getViewKickRandom()
	return vector3( 1.0, 2.0, 2.0 );
end

function getViewModel( )
	return "models/Weapons/v_Irifle.mdl";
end

function getWorldModel( )
	return "models/Weapons/w_Irifle.mdl";
end

function getClassName()
	return "weapon_blackholegun";
end

function getHUDMaterial( )
	return "gmod/SWEP/weapon_blackholegun";
end

function getDeathIcon( )
	return "d_blackholegun";
end

function getAnimPrefix()
	return "shotgun";
end

function getPrintName()
 return "\nBlack Hole Gun";
end